<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InfoGenerale extends Model 
{

    protected $table = 'info_generales';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('resume', 'contenu');

    public function modifierPar()
    {
        return $this->belongsTo('App\Models\User', 'updated_by');
    }

}